import {
   classNames,
   ExtendedFieldConfig,
   FieldLayout2,
   styleHelpers,
   useExtendedField,
} from '@yandex-infracloud-ui/libs';
import { EMPTY_VALUE } from '@yandex-infracloud-ui/libs-next';
import React, { SyntheticEvent, useCallback, useEffect, useState } from 'react';
import { botProjectApi } from 'rich_shared/BotProjectInput/botProjectApi';

import { EXTERNAL_LINKS, IBotProject } from '../../models';
import { BotProjectInput } from '../BotProjectInput/BotProjectInput';
import classes from './fields.module.css';

export const BotProjectField = (props: ExtendedFieldConfig<any, number | string | null, {}>) => {
   const [service, setService] = useState<IBotProject | null>(null);
   const { disabled, field, onBlur, onChange, showError } = useExtendedField(props);
   const { value, name } = field;

   useEffect(() => {
      // -1 - BOT проект не найден
      if (!value || value === -1) {
         setService(null);

         return;
      }

      const s = botProjectApi.getABCServiceByBotProject(Number(value)).subscribe(
         setService,
         // Ошибку подавляю, ничего страшного
         () => undefined,
      );

      return () => s.unsubscribe();
   }, [value]);

   const onSelect = useCallback((e: SyntheticEvent, projectId: number | string | null) => onChange(projectId ?? null), [
      onChange,
   ]);

   return (
      <FieldLayout2 {...props}>
         {props.disabled || props.readonly ? (
            <>{value || EMPTY_VALUE}</>
         ) : (
            <BotProjectInput
               initialQuery={String(value ?? '')}
               cls={classNames({ [classes.error]: showError })}
               name={name}
               onSelect={onSelect}
               onBlur={onBlur}
               disabled={disabled}
               {...props.controlProps}
            />
         )}
         <div style={{ display: 'block', marginTop: '0.5em' }}>
            {service ? (
               <a
                  href={EXTERNAL_LINKS.abc(String(service.planner_id))}
                  className={styleHelpers.externalLink}
                  target={'_blank'}
                  rel={'noopener noreferrer'}
               >
                  {service.en_description}
               </a>
            ) : null}
         </div>
      </FieldLayout2>
   );
};
