import { classNames, ExtendedFieldConfig, FieldLayout2, useExtendedField } from '@yandex-infracloud-ui/libs';
import * as React from 'react';
import { useCallback } from 'react';
import { IDeployConfig } from '../../models';
import { DeployConfigSelect } from '../../shared/DeployConfigSelect/DeployConfigSelect';
import classes from './fields.module.css';

export const DeployConfigField = (props: ExtendedFieldConfig<any, IDeployConfig | null, {}>) => {
   const { field, onChange, onBlur, disabled, readonly, showError } = useExtendedField(props);

   const onChangeFixed = useCallback((e, v: IDeployConfig | null) => onChange(v), [onChange]);

   return (
      <FieldLayout2 {...props}>
         <DeployConfigSelect
            initialQuery={field.value?.config ?? ''}
            cls={classNames({ [classes.error]: showError })}
            name={field.name}
            onSelect={onChangeFixed}
            onBlur={onBlur}
            disabled={disabled || readonly}
            {...props.controlProps}
         />
      </FieldLayout2>
   );
};
