import { classNames, ExtendedFieldConfig, FieldLayout2, useExtendedField } from '@yandex-infracloud-ui/libs';
import React, { SyntheticEvent, useCallback } from 'react';

import { TagInput, TagType, useProjectsTags } from '../../shared';

import classes from './fields.module.css';

export const DeployTagsField = (props: ExtendedFieldConfig<any, Set<string>, {}>) => {
   const { disabled, field, onBlur, onChange, readonly, showError } = useExtendedField(props);

   const onChangeFixed = useCallback((e: SyntheticEvent | null, v: Set<string>) => onChange(v), [onChange]);

   const getSuggestions = useProjectsTags(TagType.Deploy);

   return (
      <FieldLayout2 {...props}>
         <TagInput
            id={field.name}
            value={field.value}
            onChange={onChangeFixed}
            onBlur={onBlur}
            className={classNames({ [classes.error]: showError })}
            name={field.name}
            placeholder={props.placeholder}
            disabled={disabled || readonly}
            getSuggestions={getSuggestions}
         />
      </FieldLayout2>
   );
};

DeployTagsField.displayName = 'DeployTagsField';
