import React from 'react';
import { ExtendedFieldConfig, useExtendedField, EnumOption, FieldLayout2 } from '@yandex-infracloud-ui/libs-next';
import { RadioButton } from '@yandex-data-ui/common';

interface EnumFieldsProps {
   /**
    * Декларативный способ передать варианты для выбора в EnumField
    */
   options?: EnumOption[];
}

export const EnumField = React.memo((props: ExtendedFieldConfig<any, string, EnumFieldsProps>) => {
   const { disabled, field, readonly, onChange } = useExtendedField(props);

   return (
      <FieldLayout2 {...props}>
         <RadioButton
            onUpdate={v => onChange(v)}
            name={field.name}
            disabled={disabled || readonly}
            options={props.controlProps?.options}
            value={field.value}
         />
      </FieldLayout2>
   );
});

EnumField.displayName = 'EnumField';
