import { classNames, ExtendedFieldConfig, FieldLayout2, useExtendedField } from '@yandex-infracloud-ui/libs-next';
import React from 'react';
import { TextInputWithCounter } from '../../shared';

import classes from './fields.module.css';

export const InputWithCounterField = (props: ExtendedFieldConfig<any, string, {}>) => {
   const { disabled, field, onBlur, onChange, readonly, showError } = useExtendedField(props);

   return (
      <FieldLayout2 {...props}>
         <TextInputWithCounter
            name={field.name}
            id={field.name}
            cls={classNames({ [classes.error]: showError })}
            placeholder={props.placeholder}
            disabled={disabled}
            readonly={readonly}
            text={field.value}
            onUpdate={onChange}
            onBlur={onBlur}
            maxLength={32}
            {...props.controlProps}
         />
      </FieldLayout2>
   );
};
