import {
   classNames,
   EMPTY_VALUE,
   ExtendedFieldConfig,
   FieldLayout2,
   toasts,
   useExtendedField,
   useObservableValue,
} from '@yandex-infracloud-ui/libs';
import { Select } from 'lego-on-react';
import React, { useCallback } from 'react';
import { map } from 'rxjs/operators';

import { maintenancePlotsApi } from '../../services';
import classes from './AutomationPlotField.module.css';

import commonClasses from './fields.module.css';

export const MaintenancePlotField = (props: ExtendedFieldConfig<any, string, {}>) => {
   const { disabled, field, onBlur, onChange, readonly, showError } = useExtendedField(props);

   const plots = useObservableValue(
      maintenancePlotsApi.getList().pipe(map(resp => resp.result)),
      toasts.handleApiError('Maintenance plots loading'),
      [],
   );

   const updateValue = useCallback(
      (v: string | string[]) => {
         onChange(v[0]);
         setTimeout(onBlur); // Эмуляция отдельного события (нужно разорвать callstack)
      },
      [onBlur, onChange],
   );

   const getReadonlyValue = useCallback(() => {
      if (!field.value) {
         return EMPTY_VALUE;
      }

      const plot = (plots || []).find(p => p.id === field.value);

      return plot ? plot.meta_info.name : field.value;
   }, [field.value, plots]);

   return (
      <FieldLayout2 {...props}>
         {readonly ? (
            getReadonlyValue()
         ) : (
            // TODO заменить Select на Dropdown из ui-components
            <div data-e2e={'MaintenancePlotField:' + field.name}>
               <Select
                  theme={'normal'}
                  type={'radio'}
                  size={'s'}
                  item-icon-hidden={true}
                  cls={classNames(classes.select, { [commonClasses.error]: showError })}
                  placeholder={props.placeholder || 'Select maintenance plot'}
                  name={field.name}
                  disabled={disabled}
                  val={field.value}
                  onChange={updateValue}
               >
                  {(plots || []).map(p => (
                     <Select.Item key={p.id} val={p.id}>
                        {p.meta_info.name}
                     </Select.Item>
                  ))}
               </Select>
            </div>
         )}
      </FieldLayout2>
   );
};

MaintenancePlotField.displayName = 'MaintenancePlotField';
