import { ExtendedFieldConfig, FieldLayout2, useExtendedField } from '@yandex-infracloud-ui/libs';
import React, { SyntheticEvent, useCallback } from 'react';
import { ProjectSelect } from 'rich_shared/ProjectSelect/ProjectSelect';

import { OwnershipValue } from '../../models';

export const MyProjectSelectField = (props: ExtendedFieldConfig<any, string | null, {}>) => {
   const { disabled, field, onBlur, onChange, readonly, showError } = useExtendedField(props);

   const onSelect = useCallback(
      (e: SyntheticEvent | null, v: Set<string>) => {
         onChange(v.size > 0 ? Array.from(v)[0] : null);
         setTimeout(onBlur); // Эмуляция отдельного события (нужно разорвать колстек)
      },
      [onBlur, onChange],
   );

   return (
      <FieldLayout2 {...props}>
         <ProjectSelect
            disabled={disabled}
            error={showError}
            label={'Select project to clone'}
            name={field.name}
            onSelect={onSelect}
            ownership={OwnershipValue.My}
            readonly={readonly}
            value={field.value}
         />
      </FieldLayout2>
   );
};

MyProjectSelectField.displayName = 'MyProjectSelectField';
