import { ExtendedFieldConfig, FieldLayout2, useExtendedField } from '@yandex-infracloud-ui/libs-next';
import React, { SyntheticEvent, useCallback } from 'react';

import { OwnershipValue } from '../../models';
import { ProjectSelect } from '../ProjectSelect/ProjectSelect';

export const ProjectSelectField = (props: ExtendedFieldConfig<any, string | null, {}>) => {
   // hooks
   const { disabled, field, onBlur, onChange, readonly, showError } = useExtendedField(props);

   // handlers
   const onSelect = useCallback(
      (e: SyntheticEvent | null, v: Set<string>) => {
         onChange(v.size > 0 ? Array.from(v)[0] : null);
         setTimeout(onBlur); // Эмуляция отдельного события (нужно разорвать колстек)
      },
      [onBlur, onChange],
   );

   // render
   return (
      <FieldLayout2 {...props}>
         <ProjectSelect
            disabled={disabled}
            error={showError}
            label={'Select project'}
            name={field.name}
            onSelect={onSelect}
            ownership={OwnershipValue.All}
            readonly={readonly}
            value={field.value}
         />
      </FieldLayout2>
   );
};

ProjectSelectField.displayName = 'ProjectSelectField';
