import { classNames } from '@yandex-infracloud-ui/libs';
import React, { PropsWithChildren } from 'react';

import layoutClasses from './SimpleFieldLayout.module.css';

interface Props {
   id: string;
   label: string;
   classNameInput?: string;
}

export const SimpleFieldLayout: React.FC<PropsWithChildren<Props>> = ({ id, label, classNameInput = '', children }) => (
   <div className={classNames(layoutClasses.field)}>
      <label className={layoutClasses.label} htmlFor={id}>
         {label}
      </label>
      <div className={classNames(layoutClasses.input, classNameInput)}>{children}</div>
   </div>
);

SimpleFieldLayout.displayName = 'SimpleFieldLayout';
