import React from 'react';
import {
   ExtendedFieldConfig,
   FieldLayout2,
   useExtendedField,
   EMPTY_VALUE,
   classNames,
   isEmpty,
} from '@yandex-infracloud-ui/libs-next';
import { TextInput } from '@yandex-data-ui/common';

import classes from './fields.module.css';
import styles from './TextInputField.module.css';

interface IControlProps {
   type?: string;
   range?: {
      min?: number;
      max?: number;
   };
   units?: string;
}

export const TextInputField = (props: ExtendedFieldConfig<any, string | number | undefined | null, IControlProps>) => {
   const { field, readonly, disabled, onChange, showError, onBlur } = useExtendedField(props);
   const isInputTypeNumber = props.controlProps?.type === 'number';

   const onUpdate = (v: string | number) => {
      if (isInputTypeNumber && v === '') return onChange(null);

      onChange(isInputTypeNumber ? Number(v) : v);
   };

   return (
      <FieldLayout2 {...props}>
         {readonly ? (
            <div className={classes.readonlyValue}>{!isEmpty(field.value) ? field.value : EMPTY_VALUE}</div>
         ) : (
            <div className={styles.root}>
               <TextInput
                  {...props.controlProps}
                  placeholder={props.placeholder}
                  disabled={disabled}
                  className={classNames(props.className, { [classes.error]: showError })}
                  value={isEmpty(field.value) || field.value === null ? '' : field.value}
                  name={field.name}
                  id={field.name}
                  onUpdate={onUpdate}
                  onBlur={onBlur}
                  type={props.controlProps?.type}
                  controlProps={props.controlProps?.range}
               />
               {!isEmpty(field.value) && (
                  <small
                     className={classNames(styles.unit, {
                        [styles.unitWithNumber]: props.controlProps?.type === 'number',
                     })}
                  >
                     {props.controlProps?.units}
                  </small>
               )}
            </div>
         )}
      </FieldLayout2>
   );
};

TextInputField.displayName = 'TextInputField';
