import { action } from '@storybook/addon-actions';
import { boolean, text } from '@storybook/addon-knobs';
import { DAY_IN_SEC, ExtendedFieldConfig, json } from '@yandex-infracloud-ui/libs';
import { addSeconds } from 'date-fns';
import { Form, Formik } from 'formik';
import React from 'react';

import { TimeoutMode } from '../../models';
import { IStoryDefaults } from '../../stories/typings';

import { TimeoutField } from './TimeoutField';

const initialValue = {
   id: {
      date: addSeconds(new Date(), DAY_IN_SEC),
      mode: TimeoutMode.Date,
   },
   id2: {},
};

type Params = typeof initialValue;

function FieldStory(props: ExtendedFieldConfig<Params>) {
   return (
      <Formik
         initialValues={initialValue}
         onSubmit={action('onSubmit')}
         validateOnMount={true}
         initialTouched={{ id2: true } as any}
      >
         {form => (
            <Form>
               <TimeoutField {...props} />

               <pre>{json(form)}</pre>
            </Form>
         )}
      </Formik>
   );
}

export const Regular = () => <FieldStory name={'id'} label={'Regular'} placeholder={'Placeholder'} />;

export const Disabled = () => <FieldStory name={'id'} label={'Disabled'} disabled={true} />;

export const Readonly = () => <FieldStory name={'id'} label={'Readonly'} readonly={true} />;

export const Empty = () => <FieldStory name={'id2'} label={'Readonly & Empty'} readonly={true} />;

export const WithError = () => <FieldStory name={'id2'} label={'With error'} validate={() => 'Fake error'} />;

export const Playground = () => (
   <FieldStory
      name={'id'}
      label={text('label', 'label')}
      placeholder={text('placeholder', 'placeholder')}
      required={boolean('required', false)}
      disabled={boolean('disabled', false)}
      readonly={boolean('readonly', false)}
      help={text('help', 'help text')}
      hint={text('hint', 'short hint')}
      hidden={boolean('hidden', false)}
   />
);

export default {
   title: 'rich_shared|form_fields2/TimeoutField',
} as IStoryDefaults;
