import { classNames, ExtendedFieldConfig, FieldLayout2, useExtendedField } from '@yandex-infracloud-ui/libs-next';
import { Suggest } from '@yandex-data-ui/common';
import React, { useCallback } from 'react';
import { SuggestSelectItem } from 'shared';

import { ticketApi } from '../../services';
import { ITicket } from '../../services/api/ticket_api';

import classes from './fields.module.css';
import styles from './TrackerIssueField.module.css';

export const TrackerIssueField = (props: ExtendedFieldConfig<any, string | null, {}>) => {
   const { disabled, field, onBlur, onChange, readonly, showError } = useExtendedField(props);

   const handleChange = useCallback(
      (v: string) => {
         onChange(v || null);
      },
      [onChange],
   );
   const handleClick = useCallback(
      (v: ITicket) => {
         onChange(v.key || null);
      },
      [onChange],
   );
   const handleGetItems = useCallback(async (query): Promise<ITicket[]> => {
      if (!query) return [];

      return ticketApi
         .getTickets(query)
         .toPromise()
         .then((resp: ITicket[]) => resp.slice(0, 10));
   }, []);

   return (
      <FieldLayout2 {...props}>
         <Suggest
            getItems={handleGetItems}
            text={field.value || ''}
            onBlur={onBlur}
            className={classNames(styles.select, { [classes.error]: showError })}
            onUpdate={handleChange}
            onItemClick={handleClick}
            onInputEnterKeyDown={handleChange}
            applicableInputValue={true}
            disabled={disabled || readonly}
            placeholder={'Ticket id'}
            renderItem={item => <SuggestSelectItem title={item.key} desc={`: ${item.display}`} />}
            debounce={500}
         />
      </FieldLayout2>
   );
};

TrackerIssueField.displayName = 'TrackerIssueField';
