import {
   classNames,
   EMPTY_VALUE,
   ExtendedFieldConfig,
   FieldLayout2,
   useExtendedField,
   isEmpty,
} from '@yandex-infracloud-ui/libs-next';
import { Select } from 'lego-on-react';
import React, { useCallback } from 'react';

import { useConstants } from '../../shared';
import classes from './AutomationPlotField.module.css';

import commonClasses from './fields.module.css';

export const TypeField = (props: ExtendedFieldConfig<any, string, {}>) => {
   const { disabled, field, onBlur, onChange, readonly, showError } = useExtendedField(props);
   const { constants } = useConstants();

   const types = React.useMemo(() => (constants ? constants.host_types.filter(t => t !== 'shadow-server') : []), [
      constants,
   ]);

   const updateValue = useCallback(
      (v: string | string[]) => {
         onChange(v[0]);
         setTimeout(onBlur); // Эмуляция отдельного события (нужно разорвать callstack)
      },
      [onBlur, onChange],
   );

   return (
      <FieldLayout2 {...props}>
         {readonly ? (
            isEmpty(field.value) ? (
               EMPTY_VALUE
            ) : (
               field.value
            )
         ) : (
            // TODO заменить Select на Dropdown из ui-components
            <div data-e2e={'TypeField:' + field.name}>
               <Select
                  theme={'normal'}
                  type={'radio'}
                  size={'s'}
                  item-icon-hidden={true}
                  cls={classNames(classes.select, { [commonClasses.error]: showError })}
                  placeholder={props.placeholder || 'Select type'}
                  name={field.name}
                  disabled={disabled}
                  val={field.value}
                  onChange={updateValue}
               >
                  {types.map((p, id) => (
                     <Select.Item key={p + id} val={p}>
                        {p}
                     </Select.Item>
                  ))}
               </Select>
            </div>
         )}
      </FieldLayout2>
   );
};

TypeField.displayName = 'TypeField';
