import { IValueProps } from '@yandex-infracloud-ui/libs';
import { Icon, TextInput } from 'lego-on-react';
import * as React from 'react';

import searchIcon from '../../../../../design/icons/search.svg';

import styles from '../HostFilters.module.css';

export const FqdnField = React.memo(({ value, onChange }: IValueProps<string>) => {
   const onChangeText = (v: string) => onChange(null, v);

   return (
      <div className={styles.field}>
         <TextInput
            theme={'normal'}
            size={'s'}
            type={'text'}
            placeholder={'FQDN, inv, UUID or #tag'}
            text={value}
            hasClear={true}
            icon={<Icon size={'s'} url={searchIcon} />}
            onChange={onChangeText}
         />
      </div>
   );
});

FqdnField.displayName = 'FqdnField';
