import { ITreeOption, IValueProps, removeSetItem } from '@yandex-infracloud-ui/libs';
import { default as React, useCallback } from 'react';

import { TagList2 } from '../../../../../shared';
import { setToListOptions } from '../../../../../shared/TagList2/TagList2';

import { LocationFilter } from '../../LocationFilter/LocationFilter';
import classes from '../HostFilters.module.css';

interface IProps extends IValueProps<Set<string>> {
   locations: ITreeOption[];

   loadLocations(): void;
}

export const LocationsField = React.memo(({ locations, loadLocations, value, onChange }: IProps) => {
   const handleRemove = useCallback((v: string) => onChange(null, removeSetItem(value, v)), [onChange, value]);

   return (
      <div className={classes.field}>
         <LocationFilter value={value} onChange={onChange} locations={locations} loadLocations={loadLocations} />

         <TagList2 items={setToListOptions(value)} editable={true} className={classes.tags} onRemove={handleRemove} />
      </div>
   );
});

LocationsField.displayName = 'LocationsField';
