import { IValueProps } from '@yandex-infracloud-ui/libs';
import { Button, Icon, Ticker } from 'lego-on-react';
import { default as React, SyntheticEvent } from 'react';

import { IHostFilters, MetaStatusButtons } from '../../../../../models';

import { MetaStatusFilter } from '../../MetaStatusFilter/MetaStatusFilter';
import { getUsedAdditionalFilterCount } from '../helpers';
import styles from '../HostFilters.module.css';

interface IProps extends IValueProps<IHostFilters> {
   metaStatusButtons: MetaStatusButtons;
   opened: boolean;

   onToggle(e: SyntheticEvent): void;
}

export const MetaStatusField = React.memo(({ metaStatusButtons, opened, onToggle, value, onChange }: IProps) => {
   const usedAdditionalFilterCount = getUsedAdditionalFilterCount(value);

   return (
      <div className={styles.statusWrapper}>
         <MetaStatusFilter filters={value} buttons={metaStatusButtons} onChange={onChange} />

         <Button
            theme={'clear'}
            size={'xs'}
            cls={styles.toggleFilters}
            onClick={onToggle}
            iconRight={<Icon type={'arrow'} direction={opened ? 'top' : 'bottom'} />}
         >
            Filters
            {usedAdditionalFilterCount ? <Ticker count={usedAdditionalFilterCount} /> : null}
         </Button>
      </div>
   );
});

MetaStatusField.displayName = 'MetaStatusField';
