import { DropdownCheckboxList, IListOption, IValueProps, removeSetItem } from '@yandex-infracloud-ui/libs';
import * as React from 'react';
import { useCallback } from 'react';

import { TagList2 } from '../../../../../shared';
import { setToListOptions } from '../../../../../shared/TagList2/TagList2';

import classes from '../HostFilters.module.css';

interface IProps extends IValueProps<Set<string>> {
   label: string;
   options: IListOption[];
}

export const OptionsField = React.memo(({ options, label, value, onChange }: IProps) => {
   const handleRemove = useCallback((v: string) => onChange(null, removeSetItem(value, v)), [onChange, value]);

   const getLabel = (count: number) => `${label}: ${count || 'all'}`;

   return (
      <div className={classes.field}>
         <DropdownCheckboxList options={options} value={value} getLabel={getLabel} onChange={onChange} />
         <TagList2 items={setToListOptions(value)} editable={true} className={classes.tags} onRemove={handleRemove} />
      </div>
   );
});

OptionsField.displayName = 'OptionsField';
