import { IValueProps } from '@yandex-infracloud-ui/libs';
import * as React from 'react';

import { TagInput } from '../../../../../shared';

import styles from '../HostFilters.module.css';

interface IProps extends IValueProps<Set<string>> {
   placeholder: string;
}

export const TagsField = React.memo(({ placeholder, value, onChange }: IProps) => {
   return (
      <div className={styles.field}>
         <TagInput placeholder={placeholder} value={value} onChange={onChange} />
      </div>
   );
});

TagsField.displayName = 'TagsField';
