import { IListOption, isEqual } from '@yandex-infracloud-ui/libs';

import { IHostFilters } from '../../../../models';

import { getDefaultHostFilters } from '../../models';

export function toListOption(item: string): IListOption {
   return { value: item, name: item };
}

export function getUsedAdditionalFilterCount(value: IHostFilters) {
   const defaultFilters = getDefaultHostFilters();

   return ['locations', 'state', 'status', 'health', 'restrictions', 'switch', 'config', 'type'].reduce((acc, key) => {
      if (!isEqual(value[key], defaultFilters[key])) {
         return acc + 1;
      }

      return acc;
   }, 0);
}
