import { CheckboxSelection, CheckboxSelectionItem, IResult } from '@yandex-infracloud-ui/libs';
import * as React from 'react';
import { useMemo, useRef } from 'react';

import { HostAction } from '../../../../actions/host_actions';
import { IBoxes, IConstants, IHost, IHostSort } from '../../../../models';

import { HostRow } from '../HostRow/HostRow';
import styles from './HostList.module.css';
import { HostListHeaders } from './HostListHeaders';

interface IProps {
   boxes: IBoxes | null;
   constants: IConstants | null;
   expanded: Set<string>;
   items: IHost[];
   selected: Set<string>;
   total: number;
   sortBy: IHostSort[];

   expand(uuid: string): void;

   select(selected: Set<string>): void;

   onSortChange(sortBy: IHostSort[]): void;

   onActionFinished?(action: HostAction, results: IResult[]): void;
}

export const HostList: React.FC<IProps> = React.memo(
   ({ constants, items, total, onActionFinished, selected, select, expanded, expand, onSortChange, sortBy, boxes }) => {
      const headerRowRef = useRef<HTMLTableRowElement>(null);

      const allIds = useMemo(() => items.map(h => h.uuid), [items]);

      // const columnCount = headerRowRef.current ? headerRowRef.current.cells.length : 1;

      return (
         <CheckboxSelection allIds={allIds} value={selected} onChange={select}>
            {({ isAllSelected, toggleAll }) => (
               <table className={styles.table}>
                  <thead>
                     <tr ref={headerRowRef}>
                        <HostListHeaders
                           isAllSelected={isAllSelected}
                           toggleAll={toggleAll}
                           sortBy={sortBy}
                           onSortChange={onSortChange}
                        />
                     </tr>
                     {/*<tr>*/}
                     {/*   <td colSpan={columnCount} className={styles.totals}>*/}
                     {/*      {formatNumber(items.length)} of {formatNumber(total)} displayed*/}
                     {/*   </td>*/}
                     {/*</tr>*/}
                  </thead>
                  <tbody>
                     {items.map(host => (
                        <CheckboxSelectionItem key={host.uuid} id={host.uuid}>
                           {({ selected: checked, toggle }) => (
                              <HostRow
                                 healthGroups={constants ? constants.health_check_groups : null}
                                 boxes={boxes}
                                 expanded={expanded.has(host.uuid)}
                                 selected={checked}
                                 host={host}
                                 expand={expand}
                                 select={toggle}
                                 onActionFinished={onActionFinished}
                              />
                           )}
                        </CheckboxSelectionItem>
                     ))}
                  </tbody>
               </table>
            )}
         </CheckboxSelection>
      );
   },
);

HostList.displayName = 'HostList';
