import * as React from 'react';
import { useContext } from 'react';
import { HostListContext, LegoCheckbox } from '../../../../shared';
import styles from './HostList.module.css';
import { SortableItem } from './SortableItem';
import { IHostSort } from '../../../../models';

interface Props {
   isAllSelected: boolean | null;
   sortBy: IHostSort[];

   toggleAll(): void;

   onSortChange(sortBy: IHostSort[]): void;
}

export const HostListHeaders: React.FC<Props> = React.memo(({ isAllSelected, sortBy, toggleAll, onSortChange }) => {
   const context = useContext(HostListContext);

   const cells = [
      <th key={'checkbox'} className={styles.checkColumn}>
         <LegoCheckbox checked={isAllSelected !== false} onChange={toggleAll} indeterminate={isAllSelected === null} />
      </th>,
      <th key={'fqdn'} className={styles.withPadding}>
         <SortableItem sortBy={sortBy} name={'name'} onChange={onSortChange}>
            FQDN
         </SortableItem>
      </th>,
      context.hideProjectColumn ? null : (
         <th key={'project'} className={styles.withPadding}>
            <SortableItem sortBy={sortBy} name={'project'} onChange={onSortChange}>
               Project
            </SortableItem>
         </th>
      ),
      <th key={'type'} className={styles.withPadding}>
         <SortableItem sortBy={sortBy} name={'type'} onChange={onSortChange}>
            Type
         </SortableItem>
      </th>,
      <th key={'state'} className={styles.withPadding}>
         <SortableItem sortBy={sortBy} name={'state'} onChange={onSortChange}>
            State
         </SortableItem>
      </th>,
      <th key={'status'} className={styles.withPadding}>
         <SortableItem sortBy={sortBy} name={'status'} onChange={onSortChange}>
            Status
         </SortableItem>
      </th>,
      <th key={'health'} className={styles.withPadding}>
         <SortableItem sortBy={sortBy} name={'health'} onChange={onSortChange}>
            Health
         </SortableItem>
      </th>,
      <th key={'restrictions'} className={styles.withPadding}>
         Restrictions
      </th>,
      <th key={'switch'} className={styles.withPadding}>
         <SortableItem sortBy={sortBy} name={'switch'} onChange={onSortChange}>
            Switch
         </SortableItem>
      </th>,
      <th key={'location'} className={styles.withPadding}>
         <SortableItem sortBy={sortBy} name={'datacenter'} onChange={onSortChange}>
            Location
         </SortableItem>
      </th>,
      <th key={'links'} className={styles.withPadding}>
         <SortableItem sortBy={sortBy} name={'links'} onChange={onSortChange}>
            Links
         </SortableItem>
      </th>,
   ];

   context.additionalColumns.forEach(column => {
      cells.splice(column.order, 0, <th key={column.title}>{column.title}</th>);
   });

   return <>{cells}</>;
});

HostListHeaders.displayName = 'HostListHeaders';
