import { classNames } from '@yandex-infracloud-ui/libs';
import React, { SyntheticEvent } from 'react';
import styles from './SortableItem.module.css';

import { IHostSort, SortName, SortDirection } from '../../../../models';
import { IIconProps, SortDownIcon, SortUpIcon } from 'design/icons';

interface Props {
   sortBy: IHostSort[];
   name: SortName;
   className?: string;

   onChange(sortBy: IHostSort[]): void;
}

export const SortableItem: React.FC<Props> = ({ sortBy, name, className, children, onChange }) => {
   const direction = sortBy.find(e => e.name === name)?.direction || null;

   const iconProps: IIconProps = {
      size: 'xs',
      style: { top: direction === 'desc' ? '30%' : '15%' },
      className: classNames(styles.arrow, {
         [styles.active]: direction,
      }),
   };

   const handleClick = (event: SyntheticEvent) => {
      let d: SortDirection = null;

      if (!direction) d = 'asc';
      if (direction === 'asc') d = 'desc';

      if (!sortBy.find(e => e.name === name)) {
         onChange([...sortBy, { name, direction: d }]);
      } else {
         onChange(
            sortBy.map(e => {
               if (e.name === name) return { name, direction: d };

               return e;
            }),
         );
      }
   };

   return (
      <span className={classNames(styles.root, className)} onClick={handleClick}>
         {children} {direction === 'desc' ? <SortUpIcon {...iconProps} /> : <SortDownIcon {...iconProps} />}
      </span>
   );
};
