import { EMPTY_VALUE, formatNumber, LazyDropdown } from '@yandex-infracloud-ui/libs';
import * as React from 'react';
import { Link } from 'react-router-dom';

import { ROUTE_LINKS } from '../../../../models';

import styles from './HostRestrictions.module.css';

interface IProps {
   host: string;
   value: Set<string> | undefined;
}

export const HostRestrictions = React.memo(({ host, value }: IProps) => {
   if (!value) {
      return <>{EMPTY_VALUE}</>;
   }

   const strings = Array.from(value);

   const title =
      strings.length === 1
         ? `There is one restriction: ${strings[0]}`
         : `There are ${formatNumber(strings.length)} restrictions`;

   const switcher = (
      // eslint-disable-next-line
      <a title={title} className={styles.switcher}>
         {formatNumber(strings.length)}
      </a>
   );

   return (
      <LazyDropdown switcher={switcher} direction={'free'}>
         <div className={styles.popup}>
            <h4 className={styles.popup_header}>Restrictions:</h4>
            <ul>
               {strings.map(v => (
                  <li key={v}>
                     <Link to={ROUTE_LINKS.hostRestrictions(host)}>{v}</Link>
                  </li>
               ))}
            </ul>
         </div>
      </LazyDropdown>
   );
});

HostRestrictions.displayName = 'HostRestrictions';
