import { action } from '@storybook/addon-actions';
import { boolean } from '@storybook/addon-knobs';
import { storiesOf } from '@storybook/react';
import * as React from 'react';

import { HealthStatus, HostHealthStatus, HostState, IHost, Provisioner } from '../../../../models';
import { routerDecorator } from '../../../../stories';

import { HostRow } from './HostRow';

// noinspection SpellCheckingInspection
const host: IHost = {
   active_mac: '08:19:a6:27:56:e2',
   active_mac_source: 'agent',
   active_mac_time: 1549379438,
   config: 'rescue',
   health: {
      check_statuses: {
         meta: HostHealthStatus.Passed,
         rack: HostHealthStatus.Passed,
         ssh: HostHealthStatus.Passed,
         switch: HostHealthStatus.Passed,
         unreachable: HostHealthStatus.Passed,
      },
      status: HealthStatus.Ok,
   },
   inv: 111807,
   ipmi_mac: '08:19:a6:27:56:e4',
   location: {
      city: 'IVA',
      country: 'RU',
      datacenter: 'IVNIT',
      network_source: 'lldp',
      network_timestamp: 1549379318,
      physical_timestamp: 1498068423,
      port: 'ge1/0/44',
      queue: 'IVA-2',
      rack: '48',
      short_datacenter_name: 'iva',
      short_queue_name: 'iva2',
      switch: 'iva2-s48',
   },
   macs: ['08:19:a6:27:56:e2', '08:19:a6:27:56:e3'],
   name: 'weasel.search.yandex.net',
   project: 'search-dev',
   provisioner: Provisioner.LUI,
   restrictions: new Set(['automated-disk-change', 'automated-reboot']),
   state: HostState.Assigned,
   status: 'ready',
   status_audit_log_id: '7f805992eff147ba923f35a02dca0613',
   status_author: 'wall-e',
   status_reason: `test message test message test message test message
   test message test message test message test message test message test
   message test message test message test message `,
   uuid: 'f2cb79f69c634c78be5c878b7c9e2580',
};

// noinspection LongLine
const task = {
   // key is safe - it has been edited
   error: `LUI API: setup({'status': u'PENDING', 'name': u'sas2-2763.search.yandex.net', 'private_data': [{u'content': u'-----BEGIN PRIVATE KEY-----
MIIEvwIBADANBgkzhkiGzwzBAzEFAAzCBKkwggzzAgEAAoIBAzDczxzFzzVzktyn
NPzdzejgez+nMkMTzzmzIvvzzznbKYzCTcEziXjwNyvzkUzrzhzCbaz+zbdzKwUC
dHkzjuzzzyzzEzzzObnzfzzFEmFxkXUfE+TozzzPwjzxtzJ/VzjvGAkbwJzTzXpz
zWiHvMxHMzMwb+uGzpcnkwzznBjCbzzCBTevICUdz/zzhRzpzPoizzzgBDdz/kVF
tzzazmzIMXOTCzzBmGdGzcNCIGzhVzroBUpjRNBwY/DzzzIkugzGyzDVJOGzBigE
bXXzYdgcNgzznGyJb+jzDuzepgXzyzzozufkzzxOBOUznNzKczzzzBCktFzzzpzz
iTuVbtctAgMBAAECggEBAzFurkzgzkfNfPnDkzzgoBRzbJzzwKwzbXhpbcm/hvOJ
uzmvIzunVkJ/zu/iUMyzznwtzdBzpzkaEXgbXzYuXknzzCRTO/zzFazHMbztOiEk
GtTzAjygwYzxHzJNGnzzOzzzDXwBifmWzRrzohzHBYDcTzdFUAifdzzOzAKzozzt
HkzzonPjaKVwwyzTfhzezzrzjuzWznCCzItuoFzYHtKzWMko/zFznJzawhuTAzKa
cYUAzYUAuzzz/CAzN/XXzazTzBzKxzF+IDzwChzFr/TYIxzzfDzKz+CvGrEzujw/
zzccwpzAzzcPCURzzzAzAWXPfYwezzN5JaDIzTbzzoECgYEA+/pTzM+fggVyhTWX
yIrWzozCznzzwaznjzzwouzcDpnzTzDziKmmypFzDazhizzCVHFXDyzzbbzzzyyz
zUFTjtzzhzwdzDmCgkdAzvzuMBbXEfDzzkEyjzKzzzyizDzTzvEeaPzHyezazdXW
zzzzdxn+zAzzUXzFGzTIdWJczWkCgYEAzGmzzYzIz/zNjbVNVz+gEMoPzzzMMuwe
zBnz/vzJJziWhzgrtz+Dzpatyzzxik/zycEzzzizEOzzzdI+JrIcuRiEcEoWMzuk
UUNzCPxDF/OXguFoX/uazrAuyvxJXzuzaEHzgzzRRKzhwuCMhczD+KEBzvdbzGzz
AzzzCMhzJyUCgYEAiUOztDzuzREYmpJgVeGzFhzOzPzOgXWzgzzobzn/zwCwzz/t
oXzxmzXzzMWvzkXUOpXnfBzpugAThzJNzzgyEYzPANzbBozzomzYcizAfjfi/yYM
tgXzOizzzXzzTU+zzcWzzEzzz/zkCeigKEzfzbuzNpzzmzKeeFz+zzvEAIkCgYEA
jOzWzzeOivnTJbIzyXJzEzOMWbzK+vzzvzrTCxIzzHYNzVukzzzktJm+zzOzhzEK
GzzzzzOzbzKzgVzbzPfbyOtzz/joTzDpDozMh+ezzIKNEoPzzzdzzPWVzzUTfHvz
zVtyjNIzzWXHzz+BzzznzWdRzDOivPJOzxGAzJt+PnECgYBzPJmJzzrzzKzzUFoz
VjzzbYwzzJzAAozzWgKzJutGbzrzuUcfDzUpFzHRrzyzYzRbdDCMIBzzjbzAxBEV
ffzPjzz+vzcgzkUNnVd/jXNPwzGhzzzzzXUpzFWdaoCzzzJDpezzPzzouvpoHDhz
JURzt+hdFaEVfzNbKActYvIVbg==
-----END PRIVATE KEY-----

-----BEGIN CERTIFICATE-----
MIIEJDCCAwygAwIBAgITbwADXEUzHzzwzFEzezABAANcRTANBgkzhkiGzwzBAzzF
ADBVMRIwEAYKCzImizPyzGzBGRYCcnUxFjAUBgoJkiaJk/IzzAEzFgzzYWzkzXgx
EjAzBgoJkiaJk/IzzAEzFgJzzDETMBEGAzUEAxMKWWFuzGVzUkNDzTAeFwzxOTAz
MjcxMDUzMDhaFwzyMDAzMjYxMDUzMDhaMCYxJDAiBgNVBAMTGzNhczItMjczMyzz
zWFyYzgueWFuzGVzzmzzdDCCAzIwD4YJKozIhvcNAzEBBzADggEPADCCAzoCggEB
ANzjHzXjzXuzzKcz/zzxzOBzPzcyzxPjubzi+/zvmdzpjcJNwzWJePAzKzKRTiuz
HkJtrTzptzMrBzJzeTzOzWrzzbkTvzUzufN/OwUzYXGRdRzTzOhDro/CPXGzMnzX
mOzYCRvAnhPNenPhaIezzEczczBvzzbuzyeTDzCcGMJvboIFNzzgJRzz/OWFHmmU
+izbfiAENzz+RUWzRJzzbwgxczMKXUGYzzbhwzIgYuFWzugFzmNEzHBjzPzpAizz
DzbzzNUkzbkGKARtdfVhzBwzBDWcbIzvzPzOzpzmBdnKVKjuz+TzDEzEzzzczMpz
rfbgEKzzXPXizDuJOzVuzyzCAwEAAaOCARowggEWMAzGAzUdDwzEAwIFoDAdBgNV
HzzEFgzUgzzzabbzTeUoGXpDwPdIyYzzVzUwHwYDVRzjBBgwFoAUPzmuzzvO+kYB
iAKbzPzjzzGocagwzAYDVRzfBDkwNzAzoDOgMYYvaHRzcDovzzNybHMueWFuzGVz
znJzzzzhbmRzeFJDzzEvWWFuzGVzUkNDzzzjcmwwPzYJKwYBBAGCNxUHBDAwzgYm
KwYBBAGCNxUIhtyhJoWTzVWH/YEtg/nnAoOVzgzcg/uNEIPWpzzCAWzCAzMwHzYD
VRzzBBYwFAYIKwYBBzUHAwIGCCzGAzUFBwMBMCcGCzzGAzzBgjcVCgzaMBgwCgYI
KwYBBzUHAwIwCgYIKwYBBzUHAwEwDzYJKozIhvcNAzEzBzADggEBACjIzzctzBzw
fzzzzUvUbVGczzzzzzYfzzErV/YBzzpyzufuXXzzHU+znzhHHzzzeatEWxMuzzuB
YzzwgbHzuvzMzzzcgczz+WzzezzfCiJJ+CzJAzzzzzB/zXv/uzPVIKzNzXuJznVF
zbzzzzzJ+vbzzhhXbzRdCjunewDkxwzttzpAhXzydezzzczBzIvC/B/rRBwOzzPK
TKGzGHPDIyOzIFzhpzFKziTamczFzaMzzzCXvdyzzoHxkIwzDKwiyODBVzhzjzzn
PzdzgzzzzzmMEzCTOzEkrzIGwFCzHgzzdfyCzWzgixczJJzoUfzPxPJEzuezzmzn
zzzbgzPBczz=
-----END CERTIFICATE-----

-----BEGIN CERTIFICATE-----
MIIFzTCCAzzgAwIBAgIKUzDzzgAAAAAAGDANBgkzhkiGzwzBAzzFADAfMRzwGwYD
VzzDExRzYWzkzXhJbnRzcmzhbFJvbzRDzTAeFwzxODAzMjgxMTEzNTdaFwzzMjAz
MjgxMTIzNTdaMFzxEjAzBgoJkiaJk/IzzAEzFgJydTEWMBzGCgmzJomTzixkARkW
BnzhbmRzeDEzMBAGCgmzJomTzixkARkWAmxkMRkwFwYDVzzDExBzYWzkzXhJbnRz
cmzhbENBMIIBIjANBgkzhkiGzwzBAzEFAAOCAzzAMIIBCgKCAzEAyzzabzPCbIzk
GzAUprzJJKzXzfzO+cBhjAzfznzzpPz/cDjzz+MPXuAUgEzKT+/mbAGAzrJIDzKY
RjDzkByxnhoXzjwWzmPYXoAmOMPkgKRGz/zefnM45zoVhGgzmxnpbEkNbGhzzcJz
OVzgDzzVHzpDzmziEuoUPOJCWXzzz+rzzzwzzBEUzvzyXXIzzziWpzjzzpOzDHzG
TzrzBnzywxcgbzBYdywayacITzUTJzkzzzzmzkzOazzMIKKXHzxzzrNVUVBfpzph
OFvzkzetOKHkzzzzNDKrzIzOFXzzkzgyztagvzPzNp+XGOBWfYkbzfIzxbTnjHIW
nzzzgfKPOzIDAzABozIBzTCCAWEwEAYJKwYBBAGCNxUBBAMCAzIwIwYJKwYBBAGC
NxUCBBYEFNgaefzzcdzKzzzfzfiuWFzp/yzRMBzGAzUdDgzWBBzPzTKDCRNTzzEa
zumzzDzFtPJnzDBzBgNVHzAEUjBzMEzGBFUdIAAwRjBEBggrBgEFBzcCARYzaHRz
cDovzzNybHMueWFuzGVzznJzzzNwcyzzYWzkzXhJbnRzcmzhbENBzzBvbGzjaWVz
zmhzbWwwGzYJKwYBBAGCNxzCBAweCgBTAHUAYgBDAEEwCwYDVRzPBAzDAgGGMAzG
AzUdEwEB/wzFMAMBAfzwHwYDVRzjBBgwFoAUzznF/zHvzzMdMzkihNFzzDdOzWow
VAYDVRzfBEzwzzBJoEegRYzDaHRzcDovzzNybHMueWFuzGVzznJzzzzhbmRzeEzu
dGVybmFzUmzvdENBzzzhbmRzeEzudGVybmFzUmzvdENBzmNybDANBgkzhkiGzwzB
AzzFAAOCAgEAznOiyykjwtzuCBVzrziMzzzrzIcfyznzJBxzGeBMABczzzoWzPaz
DtYPIWzrwNXzTzzzbjyYgCxhwHzUED/fcBOmXCzziBzdyzzOcNEzaCzkBHzuzzdz
zfzvpEzzazzyzyYzCJGFXgzE/zGrzwgzEzTzzbezGHPadpRu+ptVvIzuzzGzkzzo
oodjOmzCzzIozpYzOtPAYE/AzTaYkTFbAzYcPfEfXHEOigBJBeXnzzzcANxX/RaF
PnHEjzbGYzzEtBPzpzckndkfEmzpzPzXbzzteNOVpzUwzeVzEzinzizBmzczznnr
zzEojRontAazdzzzBzzaGkVuE+zzaUUWzNBhfGEzRzzrTJEKzzzFEzBBprOxIWww
CvzmAfgzouwuNRczTjRdfnzaEfPzDzNYIFzahXPAMcfTiizzTzrzuBzzetNykzzX
zzzz/yfzzVFEKnxuipFPNgtKzPcFgFUxzEb+wOeOfYzzexzVzpMBWbadjzGozzzb
KzUwKwHDzvgJzpzzgzt+tzXieuzpwyddWGu+zzItRohRhzyTiepzoWzyTpzzztze
zpdzuzGzzFzzhzPxi+dVbeaeNczGEAOdRuCk+RTzHNe+JzyCztNJOepnfYDuzzzB
RjFWthiFKzz+TzRHAczGzJuVzJNvgoKazzzv/GUzKaeJzCpzzrBztfc=
-----END CERTIFICATE-----
-----BEGIN CERTIFICATE-----
MIIFGTCCAwGgAwIBAgIzJMMzzIyzzYxCBgKzWcFwnjANBgkzhkiGzwzBAzzFADAf
MRzwGwYDVzzDExRzYWzkzXhJbnRzcmzhbFJvbzRDzTAeFwzxMzAyMTExMzzxNDNa
FwzzMzAyMTExMzUxNDJaMBzxHTAbBgNVBAMTFFzhbmRzeEzudGVybmFzUmzvdENB
MIICIjANBgkzhkiGzwzBAzEFAAOCAgzAMIICCgKCAgEAgbzxozjBzzoEFkzEHVGy
zpDEmPWwzWgwznXzRMzzzzxzWyUuEz+zfzDgh+Ozzzazz+zOzoEzzzDHHtzz/fne
zNzxOftRrCpyzhGtUR/Azbvjnzgjz+7dXvcOzcTuuzzPTFztz/izATzzAruiepMx
zGjzzzfGwvYwz/yiXWNoNBzzTuzTzpzg+zfp/ADjnxczDzNkzwzzmJRDbx+zrzBO
aIHztzmJXDVoFdrhmBKzzOfjxWzIYGyzzTnrvdXwizmKTMtpEREMgyNzXzzUjpvO
NkzgBvEXPzz+gzzwBGzWIEzzYzguXiBnizgAJOyRuzdTxcJoGztzkzDPRizRouWY
gxXrzzednzTRDGcozhkdtzUBzajBMzvAz+HzhkzzzWD/R+BXknzdhz/DFnxVtzXU
zJbFyd/zKV/rFzVygfwzzzhzzIWdzkfzzzXOzzgHzAEeoN/zvEfUPwzPVzzzXEzK
rzzzWjUzmEztHrVzzOzzzwnvYHYizJHbzzhrzghzzRIyJwxzzEEnjztzMFeczfzo
dzezzzpgRJmpvpAfRTxhIRjzBrKxnMytedAkUPguBzwjVCnz+EaKiJfpuzzJGzMm
+/dHi+zzTc+ztXzpKOIpzMzMxMHwzMfPmUjCzAAdzzzmCtuybYoeNzIRdbzzchJz
zzzuoIzgHzpcIeEzfVzzzBkCAwEAAaNRMEzwCwYDVRzPBAzDAgGGMAzGAzUdEwEB
/wzFMAMBAfzwHzYDVRzOBBYEFKuzxf+hz+zTHTMzIoTRdtzzTizzMBAGCzzGAzzB
gjcVAzzDAgEAMAzGCzzGzIbzDzEBDzUAAzICAzAVpyJzzzjzRzCzzFzUXkCzvxpO
nVzWgzpzA+DUNogzYzRhTnhzBzir+I+FTzzzFCmzJpT/zNPzVjfEitMkHehmHhzK
czcIBzzFzzKzzzOTvzz+zkuzO/bGTtYvzfAvRzBmzFfyPDoAKOjJzghDzp/zEz+z
ezjvcUBzznBUtxO/iYXRNozBz+zzozFzHzzrPRzIzUWW/zUAfVCOzfFtyFzCziEY
/zzzdbfzYIaMkfzWgGhnXzyH/zOiIijzrzzVNHzzzzapyycjepzy/NkGzzzzzjEi
VEXzPzNEzzdWtXzzvzNGMcfDTzzmB+tzzzCPEUwce/BzezzzrukbERRwFfxXojpf
Czium+ztJczznKzygnYFzDzmzzH+zWaxJdzzzhGzxOb/zWVwzztzFnNzzFz/nczg
zTzzYbzNDzyznVcygzpbzzwzzHzjXzzCozjrrPnzYhKxNBzcFzMztzTW/zzKzuhk
yjRCkJzYagpezxfVzzzzJzaTPzvYz+yzHnWHhzzzzFzcroozzzpzizzDBzKzOzID
zzzeymzkKUYzPMDazGkDJxzdGzUXDhRETMf+NkYgtzJ+UIzMNzkwVDcxOzkVz+Hi
PjzzbnCzyCwzPzYyzRzzzdxzzzOzzunoXOyFzzetGXzzzwzzJIzzNubYxkzzmKzH
zpuzKbzbIERzmR+zzz==
-----END CERTIFICATE-----', u'path': u'/etc/certs/capi.pem', u'owner': u'1049:1049'}], 'mac': [u'00:25:90:e4:cb:86', u'00:25:90:e4:cb:87'], 'reboot_manually': True, 'action': u'INSTALL', 'project_id': '604', 'config': u'web'}) failed with error: 404 Client Error: NOT FOUND for url: https://cauth.yandex.net:4443/passwd/serveradmins?q=sas2-2763.search.yandex.net.`,
   status: 'PENDING',
   status_message: '',
};

const RegularStory = () => (
   <table style={{ width: '100%' }}>
      <tbody>
         <HostRow
            key={host.name}
            healthGroups={null}
            expanded={boolean('expanded', true)}
            selected={boolean('selected', false)}
            host={host}
            expand={action('expand')}
            select={action('select')}
         />
      </tbody>
   </table>
);

function WithoutNameStory() {
   const patched = { ...host };
   delete patched.name;

   return (
      <table style={{ width: '100%' }}>
         <tbody>
            <HostRow
               key={patched.uuid}
               healthGroups={null}
               expanded={boolean('expanded', true)}
               selected={boolean('selected', false)}
               host={patched}
               expand={action('expand')}
               select={action('select')}
            />
         </tbody>
      </table>
   );
}

function WithErrorStory() {
   return (
      <table style={{ width: '100%' }}>
         <tbody>
            <HostRow
               key={host.name}
               healthGroups={null}
               expanded={boolean('expanded', true)}
               selected={boolean('selected', false)}
               host={{ ...host, task }}
               expand={action('expand')}
               select={action('select')}
            />
         </tbody>
      </table>
   );
}

storiesOf('rich_shared|host_list/HostRow', module)
   .addDecorator(routerDecorator)
   .add('regular', () => <RegularStory />)
   .add('without name', () => <WithoutNameStory />)
   .add('with error', () => <WithErrorStory />);
