import { skipChildrenIfParentIsSelected } from './LocationFilter';

describe('LocationFilter', () => {
   it('skipChildrenIfParentIsSelected', () => {
      expect(skipChildrenIfParentIsSelected(new Set(['RU', 'BY']))).toEqual(new Set(['RU', 'BY']));

      expect(skipChildrenIfParentIsSelected(new Set(['RU', 'BY', 'RU|KK']))).toEqual(new Set(['RU', 'BY']));

      expect(skipChildrenIfParentIsSelected(new Set(['RU|XX', 'BY', 'RU|XX|YY']))).toEqual(new Set(['RU|XX', 'BY']));
   });
});
