import { autobind, DropdownCheckboxTree, formatNumber, ITreeOption } from '@yandex-infracloud-ui/libs';
import * as React from 'react';
import { SyntheticEvent } from 'react';

interface IProps {
   locations: ITreeOption[];
   value: Set<string>;

   onChange(e: SyntheticEvent, v: Set<string>): void;

   loadLocations(): void;
}

export class LocationFilter extends React.PureComponent<IProps> {
   private static _getLabel(count: number): string {
      return `Location: ${count ? formatNumber(count) : 'any'}`;
   }

   public componentDidMount(): void {
      if (this.props.locations.length === 0) {
         this.props.loadLocations();
      }
   }

   public render() {
      return (
         <div className={'location-filter'}>
            <DropdownCheckboxTree
               value={this.props.value}
               onChange={this._onChange}
               options={this.props.locations}
               getLabel={LocationFilter._getLabel}
            />
         </div>
      );
   }

   @autobind
   private _onChange(e: SyntheticEvent, v: Set<string>): void {
      const value = skipChildrenIfParentIsSelected(v);

      this.props.onChange(e, value);
   }
}

export function skipChildrenIfParentIsSelected(value: Set<string>): Set<string> {
   const filtered = Array.from(value).filter((v, _, all) => {
      // Остаются те, для которых нет среди других элементов таких элементов, с которых начинается текущий
      return !all.filter(el => el !== v).some(el => v.startsWith(el + '|'));
   });

   return new Set(filtered);
}
