import { autobind, formatNumber, formatPercent } from '@yandex-infracloud-ui/libs';
import { RadioButton } from '@yandex-data-ui/common';
import * as React from 'react';
import { SyntheticEvent } from 'react';

import { IHostFilters, MetaStatusButtons, MetaStatusValue } from '../../../../models';

import styles from './MetaStatusFilter.module.css';

interface IStatusProps {
   buttons: MetaStatusButtons;
   filters: IHostFilters;

   onChange(e: SyntheticEvent, v: IHostFilters): void;
}

export class MetaStatusFilter extends React.PureComponent<IStatusProps> {
   public render() {
      const buttons = this.props.buttons;

      return (
         <RadioButton
            onChange={this._onToggle}
            className={styles.radio}
            value={MetaStatusButtons.getValueFromFilters(this.props.filters)}
         >
            {MetaStatusButtons.config.map(b => {
               const percent = buttons.percents[b.id];
               const value = buttons.values[b.id];

               return (
                  <RadioButton.Option key={b.id} value={b.id}>
                     {b.name}

                     {percent === 1 || percent === 0 ? null : (
                        <span className={styles.percent}>{formatPercent(percent)}</span>
                     )}

                     <span className={styles.value}>{formatNumber(value)}</span>
                  </RadioButton.Option>
               );
            })}
         </RadioButton>
      );
   }

   @autobind
   private _onToggle(e: React.ChangeEvent<HTMLInputElement>) {
      const previousFilters: IHostFilters = { ...this.props.filters };
      const filters = MetaStatusButtons.patchFilters(previousFilters, e.target.value as MetaStatusValue);

      this.props.onChange(e, filters);
   }
}
