import { queryValueToSet, setToQueryValue } from '@yandex-infracloud-ui/libs';

import { IHostFilters, OwnershipValue, ProjectType } from '../../models';
import { config } from '../../services';

export interface IHostUrlParams {
   config?: string;
   fqdn?: string;
   health?: string;
   locations?: string;
   ownership?: OwnershipValue;
   project?: string;
   restrictions?: string;
   state?: string;
   status?: string;
   switch?: string;
   type?: string;
}

export function hostFiltersToUrlParams(filters: IHostFilters): IHostUrlParams {
   return {
      config: setToQueryValue(filters.config),
      fqdn: filters.fqdn,
      health: setToQueryValue(filters.health),
      locations: setToQueryValue(filters.locations),
      ownership: filters.ownership === config.ownershipDefault ? undefined : filters.ownership,
      project: setToQueryValue(filters.project),
      restrictions: setToQueryValue(filters.restrictions),
      state: setToQueryValue(filters.state),
      status: setToQueryValue(filters.status),
      switch: setToQueryValue(filters.switch),
      type: setToQueryValue(filters.type),
   };
}

export type ForcedHostFilters = Partial<IHostFilters>;

export function urlParamsToHostFilters(query: IHostUrlParams): IHostFilters {
   return {
      config: queryValueToSet(query.config),
      fqdn: query.fqdn || '',
      health: queryValueToSet(query.health),
      locations: queryValueToSet(query.locations),
      ownership: query.ownership || config.ownershipDefault,
      project: queryValueToSet(query.project),
      restrictions: queryValueToSet(query.restrictions),
      state: queryValueToSet(query.state),
      status: queryValueToSet(query.status),
      switch: queryValueToSet(query.switch),
      type: queryValueToSet(query.type),
   };
}

export function getDefaultHostFilters(): IHostFilters {
   return {
      config: new Set(),
      fqdn: '',
      health: new Set(),
      locations: new Set(),
      ownership: config.ownershipDefault,
      project: new Set(),
      restrictions: new Set(),
      state: new Set(),
      status: new Set(),
      switch: new Set(),
      type: new Set(Object.values(ProjectType)),
   };
}

export enum SelectMode {
   Page = 'page',
   AllPages = 'allPages',
}
