import { action } from '@storybook/addon-actions';
import { modalService, toasts, useDismounted } from '@yandex-infracloud-ui/libs';
import { Button } from 'lego-on-react';
import React, { useCallback } from 'react';
import { takeUntil } from 'rxjs/operators';

import { modalsSupportDecorator, toastsSupportDecorator } from '../../stories';
import { IStoryDefaults } from '../../stories/typings';

import { DnsDomainModal } from './DnsDomainModal';

export const Regular = () => <DnsDomainModal ok={action('ok')} cancel={action('cancel')} id={'test'} dnsDomain={''} />;

export const WithDefault = () => (
   <DnsDomainModal ok={action('ok')} cancel={action('cancel')} id={'test'} dnsDomain={'search.yandex.net'} />
);

export const Modal = () => {
   const dismounted = useDismounted();

   const open = useCallback(() => {
      modalService
         .open(DnsDomainModal, { id: 'test', dnsDomain: '' }, false)
         .pipe(takeUntil(dismounted))
         .subscribe(v => {
            toasts.success('DNS-domain has been updated');
            action('success')(v);
         }, action('error or dismiss'));
   }, [dismounted]);

   return (
      <Button theme={'action'} size={'s'} onClick={open}>
         Open modal
      </Button>
   );
};

export default {
   decorators: [modalsSupportDecorator, toastsSupportDecorator],
   title: 'rich_shared|project_automations/DnsDomainModal',
} as IStoryDefaults;
