import { action } from '@storybook/addon-actions';
import { modalService, toasts, useDismounted } from '@yandex-infracloud-ui/libs';
import { Button } from 'lego-on-react';
import React, { useCallback } from 'react';
import { takeUntil } from 'rxjs/operators';

import { modalsSupportDecorator, toastsSupportDecorator, userSwitcherDecorator } from '../../stories';
import { IStoryDefaults } from '../../stories/typings';

import { Automation } from 'models';
import { DnsOffModal } from './DnsOffModal';

const dnsAutomation: Automation = {
   enabled: false,
};

export const Form = () => (
   <DnsOffModal id={'test1'} dnsAutomation={dnsAutomation} ok={action('ok')} cancel={action('cancel')} />
);

export const Modal = () => {
   const dismounted = useDismounted();

   const open = useCallback(() => {
      modalService
         .open(DnsOffModal, { id: 'test', dnsAutomation }, false)
         .pipe(takeUntil(dismounted))
         .subscribe(v => {
            toasts.success('DNS-automation has been turned off');
            action('success')(v);
         }, action('error or dismiss'));
   }, [dismounted]);

   return (
      <Button theme={'action'} size={'s'} onClick={open}>
         Open modal
      </Button>
   );
};

export default {
   decorators: [modalsSupportDecorator, toastsSupportDecorator, userSwitcherDecorator],
   title: 'rich_shared|project_automations/DnsOffModal',
} as IStoryDefaults;
