import { action } from '@storybook/addon-actions';
import { modalService, toasts, useDismounted } from '@yandex-infracloud-ui/libs';
import { Button } from 'lego-on-react';
import React, { useCallback } from 'react';
import { takeUntil } from 'rxjs/operators';
import { modalsSupportDecorator, toastsSupportDecorator, userSwitcherDecorator } from '../../stories';

import { IStoryDefaults } from '../../stories/typings';

import { DnsOnModal } from './DnsOnModal';

export const Form = () => {
   return <DnsOnModal dnsDomain={'search.yandex.net'} id={'test1'} ok={action('ok')} cancel={action('cancel')} />;
};

export const Modal = () => {
   const dismounted = useDismounted();

   const open = useCallback(() => {
      modalService
         .open(DnsOnModal, { id: 'test', dnsDomain: '' }, false)
         .pipe(takeUntil(dismounted))
         .subscribe(v => {
            toasts.success('DNS-automation has been turned on');
            action('success')(v);
         }, action('error or dismiss'));
   }, [dismounted]);

   return (
      <Button theme={'action'} size={'s'} onClick={open}>
         Open modal
      </Button>
   );
};
export default {
   decorators: [modalsSupportDecorator, toastsSupportDecorator, userSwitcherDecorator],
   title: 'rich_shared|project_automations/DnsOnModal',
} as IStoryDefaults;
