import { action } from '@storybook/addon-actions';
import { modalService, toasts, useDismounted } from '@yandex-infracloud-ui/libs';
import { Button } from 'lego-on-react';
import React, { useCallback } from 'react';
import { takeUntil } from 'rxjs/operators';
import { modalsSupportDecorator, toastsSupportDecorator } from '../../stories';

import { IStoryDefaults } from '../../stories/typings';

import { Automation } from 'models';
import { HealingOffModal } from './HealingOffModal';

const healingAutomation: Automation = {
   enabled: false,
};

export const Form = () => {
   return (
      <HealingOffModal id={'test1'} healingAutomation={healingAutomation} ok={action('ok')} cancel={action('cancel')} />
   );
};

export const Modal = () => {
   const dismounted = useDismounted();

   const open = useCallback(() => {
      modalService
         .open(HealingOffModal, { id: 'test', healingAutomation }, false)
         .pipe(takeUntil(dismounted))
         .subscribe(v => {
            toasts.success('Healing has been turned off');
            action('success')(v);
         }, action('error or dismiss'));
   }, [dismounted]);

   return (
      <Button theme={'action'} size={'s'} onClick={open}>
         Open modal
      </Button>
   );
};
export default {
   decorators: [modalsSupportDecorator, toastsSupportDecorator],
   title: 'rich_shared|project_automations/HealingOffModal',
} as IStoryDefaults;
