import { action } from '@storybook/addon-actions';
import { modalService, toasts, useDismounted } from '@yandex-infracloud-ui/libs';
import { Button } from 'lego-on-react';
import React, { useCallback } from 'react';
import { takeUntil } from 'rxjs/operators';
import { modalsSupportDecorator, toastsSupportDecorator } from '../../stories';

import { IStoryDefaults } from '../../stories/typings';

import { HealingOnModal } from './HealingOnModal';

export const Form = () => {
   return <HealingOnModal id={'test1'} ok={action('ok')} cancel={action('cancel')} />;
};

export const Modal = () => {
   const dismounted = useDismounted();

   const open = useCallback(() => {
      modalService
         .open(HealingOnModal, { id: 'test' }, false)
         .pipe(takeUntil(dismounted))
         .subscribe(v => {
            toasts.success('Healing has been turned on');
            action('success')(v);
         }, action('error or dismiss'));
   }, [dismounted]);

   return (
      <Button theme={'action'} size={'s'} onClick={open}>
         Open modal
      </Button>
   );
};
export default {
   decorators: [modalsSupportDecorator, toastsSupportDecorator],
   title: 'rich_shared|project_automations/HealingOnModal',
} as IStoryDefaults;
