import { action } from '@storybook/addon-actions';
import { boolean, text } from '@storybook/addon-knobs';
import React from 'react';

import { modalsSupportDecorator, routerDecorator, toastsSupportDecorator, userSwitcherDecorator } from '../../stories';
import { IStoryDefaults } from '../../stories/typings';

import { ProjectAutomationTumblers } from './ProjectAutomationTumblers';

export const AllIsOk = () => (
   <ProjectAutomationTumblers
      disabled={boolean('disabled', false)}
      projectId={'test'}
      projectName={'test'}
      dnsDomain={text('dnsDomain', 'search.yandex.net')}
      dnsAutomation={{ enabled: true }}
      fsmEnabled={false}
      healingAutomation={{ enabled: true }}
      onChange={action('onChange')}
   />
);

export const AllIsInvalid = () => (
   <ProjectAutomationTumblers
      disabled={boolean('disabled', false)}
      projectId={'test'}
      projectName={'test'}
      dnsDomain={'search.yandex.net'}
      dnsAutomation={{ enabled: false }}
      fsmEnabled={true}
      fsmDetails={{
         reason: 'test',
         ticket_key: 'WALLEUI-639',
         timeout_time: 1579354680,
      }}
      healingAutomation={{ enabled: false }}
      onChange={action('onChange')}
   />
);

export const HealingAutomationIsInvalid = () => (
   <ProjectAutomationTumblers
      disabled={boolean('disabled', false)}
      projectId={'test'}
      projectName={'test'}
      dnsDomain={text('dnsDomain', 'search.yandex.net')}
      dnsAutomation={{ enabled: true }}
      fsmEnabled={false}
      healingAutomation={{ enabled: false }}
      onChange={action('onChange')}
   />
);

export const DNSAutomationIsInvalid = () => (
   <ProjectAutomationTumblers
      disabled={boolean('disabled', false)}
      projectId={'test'}
      projectName={'test'}
      dnsDomain={text('dnsDomain', 'search.yandex.net')}
      dnsAutomation={{ enabled: false }}
      fsmEnabled={false}
      healingAutomation={{ enabled: true }}
      onChange={action('onChange')}
   />
);

export const FSMAutomationIsInvalid = () => (
   <ProjectAutomationTumblers
      disabled={boolean('disabled', false)}
      projectId={'test'}
      projectName={'test'}
      dnsDomain={text('dnsDomain', 'search.yandex.net')}
      dnsAutomation={{ enabled: true }}
      fsmEnabled={true}
      fsmDetails={{
         reason: 'test',
         ticket_key: 'WALLEUI-639',
         timeout_time: Date.now() / 990,
      }}
      healingAutomation={{ enabled: true }}
      onChange={action('onChange')}
   />
);

export default {
   decorators: [modalsSupportDecorator, toastsSupportDecorator, userSwitcherDecorator, routerDecorator],
   title: 'rich_shared|project_automations/ProjectAutomationTumblers',
} as IStoryDefaults;
