import { action } from '@storybook/addon-actions';
import { toTimestamp } from '@yandex-infracloud-ui/libs';
import { addSeconds } from 'date-fns';
import React from 'react';
import { ProjectItem } from '../../state/projects/models';
import {
   modalsSupportDecorator,
   outlineDecorator,
   routerDecorator,
   toastsSupportDecorator,
   userSwitcherDecorator,
} from '../../stories';

import { IStoryDefaults } from '../../stories/typings';

import { ProjectListAutomationTumblers } from './ProjectListAutomationTumblers';

const items: ProjectItem[] = [
   {
      dns_automation: { enabled: true },
      fsm_handbrake: {
         timeout_time: toTimestamp(addSeconds(new Date(), 10)),
      },
      healing_automation: { enabled: false },
      id: 'test',
      name: 'Testing',
      tags: [],
   },
   {
      dns_automation: { enabled: true },
      fsm_handbrake: {
         timeout_time: toTimestamp(addSeconds(new Date(), 10)),
      },
      healing_automation: { enabled: false },
      id: 'item1',
      name: 'Item 1 (fsm deadline after 10 seconds)',
      tags: [],
   },
   {
      dns_automation: { enabled: false },
      dns_domain: 'search.yandex.net',
      healing_automation: { enabled: false },
      id: 'item2',
      name: 'Item 2',
      tags: [],
   },
   {
      dns_automation: { enabled: false },
      fsm_handbrake: {
         timeout_time: 1610890823,
      },
      healing_automation: { enabled: true },
      id: 'item3',
      name: 'Item 3 (no dns_domain)',
      tags: [],
   },
];

export const Regular = () => <ProjectListAutomationTumblers items={items} onChange={action('onChange')} />;

export default {
   decorators: [
      modalsSupportDecorator,
      outlineDecorator,
      routerDecorator,
      toastsSupportDecorator,
      userSwitcherDecorator,
   ],
   title: 'rich_shared|project_automations/ProjectListAutomationTumblers',
} as IStoryDefaults;
