import { DISMISS_REASON, IModalProps, ModalLayout } from '@yandex-infracloud-ui/libs';
import React, { useCallback } from 'react';

import { ProjectItem } from '../../state/projects/models';
import { ProjectListAutomationTumblers } from './ProjectListAutomationTumblers';

interface Props extends IModalProps<string> {
   items: ProjectItem[];
}

export const ProjectListAutomationTumblersModal: React.FC<Props> = React.memo(({ items, ok, cancel }) => {
   const handleDismiss = useCallback(() => cancel(DISMISS_REASON), [cancel]);

   const handleChange = useCallback((projectId: string) => ok(projectId), [ok]);

   return (
      <ModalLayout onDismiss={handleDismiss} title={'Automations'} showFooter={false}>
         <ProjectListAutomationTumblers items={items} onChange={handleChange} />
      </ModalLayout>
   );
});

ProjectListAutomationTumblersModal.displayName = 'ProjectListAutomationTumblersModal';
