import { DurationField, ExtendedFieldConfig, InputField2, useExtendedField } from '@yandex-infracloud-ui/libs';
import React, { useCallback, useState } from 'react';
import { AutomationType } from '../../../models';
import { AddCreditButton } from './AddCreditButton';

import classes from './CreditField.module.css';

interface CreditFieldControlProps {
   automationType: AutomationType;
}

// TODO либо переделать в сабформу, либо в нормальное поле со вложенной формой
export const CreditField = (props: ExtendedFieldConfig<any, unknown, CreditFieldControlProps>) => {
   if (!props.controlProps?.automationType) {
      throw new Error('You must define automationType for controlProps. See enum AutomationType');
   }

   const { automationType } = props.controlProps;

   const { field, disabled, readonly } = useExtendedField(props);

   const [creditFields, setCreditFields] = useState<string[]>([]);

   const addCreditField = useCallback((credit: string) => setCreditFields(v => [...v, credit]), []);

   return (
      <>
         <DurationField name={`${field.name}.time`} label={'Credit time'} disabled={disabled} readonly={readonly} />

         {creditFields.map(f => (
            <InputField2
               key={f}
               controlProps={{ type: 'number' }}
               name={`${field.name}.${f}`}
               label={f}
               placeholder={'Optional credit'}
               disabled={disabled}
               readonly={readonly}
            />
         ))}

         {disabled || readonly ? null : (
            <AddCreditButton
               className={classes.addButton}
               alreadyUsed={creditFields}
               type={automationType}
               onSelect={addCreditField}
            />
         )}
      </>
   );
};
