import { ExtendedFieldConfig, InputField2, useExtendedField } from '@yandex-infracloud-ui/libs';
import React from 'react';
import { useSuggestionForLego } from '../../../shared';

const suggestedDnsDomains = [
   'search.yandex.net',
   'qloud-h.yandex.net',
   'market.yandex.net',
   'cloud.yandex.net',
   'yp.yandex.net',
   'metrika.yandex.net',
   'qloud.yandex.net',
   'qloud-vm.yandex.net',
   // '.yt.yandex.net$',
   // 'crypta.yandex.net', // @n-malakhov: "хотя, крипту, кажется, запретили"
   // 'rtcrypta.yandex.net',
];

export const DnsDomainField: React.FC<ExtendedFieldConfig> = React.memo(props => {
   const { readonly } = useExtendedField(props);
   const suggestionProps = useSuggestionForLego(suggestedDnsDomains);

   return (
      <InputField2
         name={props.name}
         placeholder={props.placeholder || 'Enter DNS domain'}
         label={props.label || 'DNS-automation domain'}
         help={props.help}
         readonly={readonly}
         // TODO добавить поддержку пропсов от TextInput в InputField2
         controlProps={suggestionProps as any}
      />
   );
});

DnsDomainField.displayName = 'DnsDomainField';
