import { ExtendedFieldConfig, InputField2, useExtendedField } from '@yandex-infracloud-ui/libs';
import React from 'react';

export const DnsZoneIdField: React.FC<ExtendedFieldConfig> = React.memo(props => {
   const { readonly } = useExtendedField(props);

   return (
      <InputField2
         name={props.name}
         placeholder={props.placeholder || 'Enter DNS Zone ID'}
         label={props.label || 'YC DNS Zone ID'}
         help={props.help}
         readonly={readonly}
      />
   );
});

DnsZoneIdField.displayName = 'DnsZoneIdField';
