import React from 'react';
import { DnsDomainModal } from './DnsDomainModal';
import { DnsOffModal } from './DnsOffModal';
import { DnsOnModal } from './DnsOnModal';
import { FsmOffModal } from './FsmOffModal';
import { FsmOnModal } from './FsmOnModal';
import { HealingOffModal } from './HealingOffModal';
import { HealingOnModal } from './HealingOnModal';

/**
 * @file
 *
 * Т.к. в ProjectAutomationTumblers изначально было очень много похожей логики для переключения разных видов автоматик,
 * то было решено вынести эту логику в конфигурационный файл.
 */

export enum AutomationModals {
   DNS = 'dns',
   FSM = 'fsm',
   Healing = 'healing',
   DnsDomain = 'dns_domain',
   FsmRenew = 'fsm_renew',
}

interface AutomationConfig {
   off: {
      component: React.FC<any>;
      successMessage: string;
      failureMessage: string;
   };
   on: {
      component: React.FC<any>;
      successMessage: string;
      failureMessage: string;
   };
}

export const modalConfigs = new Map<AutomationModals, AutomationConfig>([
   [
      AutomationModals.Healing,
      {
         off: {
            component: HealingOffModal,
            failureMessage: 'Healing automation turning off',
            successMessage: 'Healing automation has been turned off',
         },
         on: {
            component: HealingOnModal,
            failureMessage: 'Healing automation turning on',
            successMessage: 'Healing automation has been turned on',
         },
      },
   ],
   [
      AutomationModals.DNS,
      {
         off: {
            component: DnsOffModal,
            failureMessage: 'DNS automation turning off',
            successMessage: 'DNS automation has been turned off',
         },
         on: {
            component: DnsOnModal,
            failureMessage: 'DNS automation turning on',
            successMessage: 'DNS automation has been turned on',
         },
      },
   ],
   [
      AutomationModals.DnsDomain,
      {
         off: {
            component: DnsDomainModal,
            failureMessage: 'DNS-domain editing',
            successMessage: 'DNS-domain has been edited',
         },
         // copy of 'off'
         on: {
            component: DnsDomainModal,
            failureMessage: 'DNS-domain editing',
            successMessage: 'DNS-domain has been edited',
         },
      },
   ],
   [
      AutomationModals.FSM,
      {
         off: {
            component: FsmOffModal,
            failureMessage: 'FSM-handbrake turning off',
            successMessage: 'FSM-handbrake has been turned off',
         },
         on: {
            component: FsmOnModal,
            failureMessage: 'FSM-handbrake turning on',
            successMessage: 'FSM-handbrake has been turned on',
         },
      },
   ],
   [
      AutomationModals.FsmRenew,
      {
         off: {
            component: FsmOnModal,
            failureMessage: 'FSM-handbrake updating',
            successMessage: 'FSM-handbrake has been updated',
         },
         on: {
            component: FsmOnModal,
            failureMessage: 'FSM-handbrake updating',
            successMessage: 'FSM-handbrake has been updated',
         },
      },
   ],
]);
