import { ISuggestBaseEntity, ISuggestStrategy, SuggestLayer } from '@yandex-infracloud-ui/libs';
import * as React from 'react';
import { Observable, of } from 'rxjs';
import { getTrackerFieldName, TICKET_SYSTEM_FIELDS } from './models';

export interface ISuggestTicketField extends ISuggestBaseEntity {
   id: string;
}

// TODO перенести в ui-components
class TicketFieldStrategy implements ISuggestStrategy {
   public getPlaceholder(): string {
      return 'Find system field or add custom';
   }

   public getQueryFromEntity(entity: ISuggestTicketField): string {
      return entity ? entity.id : '';
   }

   public getEntityFromQuery(query: string, suggestions: ISuggestTicketField[]): ISuggestTicketField {
      query = query.toLowerCase();

      const exist = suggestions.find(s => s.title === query);
      if (exist) {
         return exist;
      }

      return {
         id: query,
         layer: SuggestLayer.People,
         title: getTrackerFieldName(query),
         url: '',
      };
   }

   public load(query: string): Observable<ISuggestTicketField[]> {
      const q = query.toLowerCase();

      const fields = TICKET_SYSTEM_FIELDS.filter(field =>
         [field.value, field.name].map(v => v.toLowerCase()).some(v => v.includes(q)),
      ).map(field => {
         return {
            id: field.value,
            layer: 'TrackerTicket' as SuggestLayer,
            title: field.name,
            url: '',
         } as ISuggestTicketField;
      });

      return of(fields);
   }

   public renderItem(entity: ISuggestTicketField): JSX.Element {
      return <div>{entity.title}</div>;
   }
}

export const ticketFieldStrategy = new TicketFieldStrategy();
