import { LazyDropdown } from '@yandex-infracloud-ui/libs';
import { Button, Icon } from 'lego-on-react';
import * as React from 'react';
import { SyntheticEvent, useCallback, useState } from 'react';

import addSvg from '../../../design/icons/add.svg';

import styles from './FindTicketFieldButton.module.css';
import { FindTicketFieldPopup } from './FindTicketFieldPopup';

interface IProps {
   name?: string;
   onSelect(e: SyntheticEvent | null, field: string): void;
}

export const FindTicketFieldButton = React.memo(({ name, onSelect }: IProps) => {
   // region hooks
   const [opened, setOpened] = useState(false);
   // endregion

   // region handlers
   const onChangeOpened = useCallback((v: boolean) => setOpened(v), []);

   const close = useCallback(() => setOpened(false), []);

   const submit = useCallback(
      (e: SyntheticEvent | null, field: string) => {
         if (field) {
            onSelect(e, field);
            close();
         }
      },
      [close, onSelect],
   );
   // endregion

   // region render
   const switcher = (
      <Button
         name={'add-field-button'}
         theme={'clear'}
         size={'s'}
         cls={styles.findTicketFieldButton}
         icon={<Icon url={addSvg} />}
      />
   );

   return (
      <LazyDropdown switcher={switcher} opened={opened} onChangeOpened={onChangeOpened}>
         <FindTicketFieldPopup name={name} onCancel={close} onSubmit={submit} />
      </LazyDropdown>
   );
   // endregion
});

FindTicketFieldButton.displayName = 'FindTicketFieldButton';
