import { Suggest } from '@yandex-data-ui/common';
// import { SuggestSelect } from '@yandex-infracloud-ui/libs';
import * as React from 'react';
import { SyntheticEvent, useCallback, useState } from 'react';

import { SuggestSelectItem } from 'shared';

import { ISuggestTicketField, ticketFieldStrategy } from '../TicketFieldStrategy';
import styles from './FindTicketFieldPopup.module.css';

interface IProps {
   name?: string;

   onSubmit(e: SyntheticEvent | null, key: string | null): void;

   onCancel(e: SyntheticEvent): void;
}

export const FindTicketFieldPopup = React.memo(({ name, onSubmit }: IProps) => {
   // region hooks
   const [value, setValue] = useState('');
   // endregion

   // region handlers
   const onSelect = useCallback(
      (item: ISuggestTicketField | null) => {
         if (item === null) {
            return;
         }

         const fieldId = ticketFieldStrategy.getQueryFromEntity(item);
         setValue('');

         onSubmit(null, fieldId);
      },
      [onSubmit],
   );

   const onChange = useCallback(
      (v: string) => {
         setValue('');
         onSubmit(null, v);
      },
      [onSubmit],
   );

   const handleGetItems = useCallback(async (query): Promise<ISuggestTicketField[] | any> => {
      if (!query) return [];

      return ticketFieldStrategy
         .load(query)
         .toPromise()
         .then(resp => resp.slice(0, 10));
   }, []);

   // endregion

   // region render
   return (
      <div className={styles.popup}>
         <Suggest
            getItems={handleGetItems}
            text={value}
            getItemsOnMount={true}
            onUpdate={setValue}
            onInputEnterKeyDown={onChange}
            onItemClick={onSelect}
            applicableInputValue={true}
            placeholder={'Find system field or add custom'}
            renderItem={item => <SuggestSelectItem title={item ? item.id : ''} />}
            debounce={500}
            syncPopupOnResize={false}
         />
      </div>
   );
   // endregion
});

FindTicketFieldPopup.displayName = 'FindTicketFieldPopup';
