import { boolean } from '@storybook/addon-knobs';
import { json } from '@yandex-infracloud-ui/libs';
import React from 'react';

import { IStoryDefaults } from '../../../stories/typings';
import { initialState } from '../../../state/fullProjectForm';
import { useFormParams } from '../../../stories/reactHooks';

import { ProjectReportSettingsForm } from './ProjectReportSettingsForm';

function RegularStory() {
   const [{ params, validation }, updateParams] = useFormParams(initialState.reports);

   return (
      <>
         <ProjectReportSettingsForm
            readonly={boolean('readonly', false)}
            value={params}
            validation={validation}
            onChange={updateParams}
         />

         <pre>{json(params)}</pre>
      </>
   );
}

export const Regular = () => <RegularStory />;

export default {
   title: 'rich_shared|project_report_settings/ProjectReportsSettings',
} as IStoryDefaults;
