import { FormLayout, isEqual, styleHelpers, useIgnoreEvent } from '@yandex-infracloud-ui/libs';
import * as React from 'react';
import { reportsFields } from '../formFields';

import { FormProps } from 'routes/project/models';
import { IProjectReports } from '../models';
import { Card } from '@yandex-data-ui/common';
import { initialState } from 'state/fullProjectForm';
import { EXTERNAL_LINKS } from 'models';

interface Props extends FormProps<IProjectReports> {
   readonly?: boolean;
}

/**
 * Форма настроект отчётов у проекта
 *
 * Используется при создании и редактировании проекта
 */
export const ProjectReportSettingsForm = React.memo(({ readonly = false, value, onChange, validation }: Props) => {
   const showWarning = isEqual(initialState.reports.params, value);

   return (
      <>
         {showWarning && (
            <div style={{ display: 'flex', marginBottom: '1.75rem' }}>
               <Card theme={'warning'}>
                  <div style={{ padding: 10, maxWidth: 650 }}>
                     <strong>Reports will be generated</strong>
                     <br />
                     The report settings are set by default. Change the settings and you will have an explicit option to
                     enable and disable reports. To learn more, refer to the{' '}
                     <a
                        href={EXTERNAL_LINKS.walleDocsGuide('reports')}
                        target={'_blank'}
                        rel={'noopener noreferrer'}
                        className={styleHelpers.externalLink}
                     >
                        guide
                     </a>
                  </div>
               </Card>
            </div>
         )}
         <FormLayout
            fields={reportsFields}
            onChange={useIgnoreEvent(onChange)}
            readonly={readonly}
            validationResult={validation}
            value={value}
         />
      </>
   );
});

ProjectReportSettingsForm.displayName = 'ProjectReportSettingsForm';
