import { FormFieldType, FormLayout, IFieldProps, IFormField } from '@yandex-infracloud-ui/libs';
import * as React from 'react';
import { SyntheticEvent, useState } from 'react';
// noinspection TypeScriptPreferShortImport,ES6PreferShortImport
import { FindTicketFieldButton } from '../components/FindTicketFieldButton';
import { getTrackerFieldName, IProjectReportsExtra } from '../models';
import styles from './ReportsExtraFields.module.css';

export const ReportsExtraFields = React.memo((props: IFieldProps<IProjectReportsExtra>) => {
   // in case component was unmounted because of isHidden
   const getInitialFields = (): IFormField<IProjectReportsExtra>[] => {
      if (!props.value) {
         return [];
      }

      return Object.keys(props.value).map(key => ({
         label: getTrackerFieldName(key),
         name: key,
         type: FormFieldType.String,
      }));
   };

   // region hooks
   const [fields, setFields] = useState(getInitialFields);
   // endregion

   // region handlers
   const updateFields = (e: SyntheticEvent, newField: string) => {
      // field with selected id already exists, skip
      if (fields.map(el => el.name.toString()).includes(newField)) {
         return;
      }

      setFields([
         ...fields,
         {
            label: getTrackerFieldName(newField),
            name: newField,
            type: FormFieldType.String,
         },
      ]);

      props.onChange(null, { ...props.value, [newField]: '' });
   };
   // endregion

   // region render
   if (props.readonly && fields.length === 0) {
      return null;
   }

   return (
      <>
         <h4 className={styles.fullWidth}>Extra ticket fields</h4>

         {fields.length > 0 ? (
            <div className={styles.fullWidth}>
               <FormLayout
                  readonly={props.readonly}
                  value={props.value || {}}
                  onChange={props.onChange}
                  fields={fields}
               />
            </div>
         ) : null}

         {props.readonly ? null : (
            <div className={styles.valueColumn}>
               Add field
               <FindTicketFieldButton name={props.config.name} onSelect={updateFields} />
            </div>
         )}
      </>
   );
   // endregion
});
