import { Suggest } from '@yandex-data-ui/common';
import {
   EMPTY_VALUE,
   FieldLayout,
   getStrategy,
   IFieldProps,
   ISuggestBaseEntity,
   SuggestLayer,
} from '@yandex-infracloud-ui/libs';
import * as React from 'react';
import { useCallback } from 'react';

import { SuggestSelectItem } from 'shared';

export const TrackerQueueField = React.memo((props: IFieldProps<string>) => {
   const { value, disabled } = props;
   // region helpers
   const strategy = getStrategy(SuggestLayer.Queues);
   // endregion

   // region handlers
   const onSelect = (item: ISuggestBaseEntity | null) => {
      if (item === null) {
         props.onChange(null, '');
      } else {
         const id = strategy.getQueryFromEntity(item);

         props.onChange(null, id);
      }
   };
   const onQueryChange = useCallback(
      (v: string) => {
         props.onChange(null, v);
      },
      [props],
   );

   const handleGetItems = useCallback(
      async (query): Promise<ISuggestBaseEntity[] | any> => {
         if (!query) return [];

         return strategy
            .load(query)
            .toPromise()
            .then(resp => resp.slice(0, 10));
      },
      [strategy],
   );
   // endregion

   // region render
   return (
      <FieldLayout config={props.config} help={props.help} error={props.error}>
         {props.readonly ? (
            props.value || EMPTY_VALUE
         ) : (
            <Suggest
               getItems={handleGetItems}
               text={value}
               getItemsOnMount={true}
               onUpdate={onQueryChange}
               onInputEnterKeyDown={onQueryChange}
               onItemClick={onSelect}
               applicableInputValue={true}
               placeholder={'Tracker queue'}
               renderItem={item => <SuggestSelectItem title={item ? String(item.id) : ''} />}
               disabled={disabled}
               debounce={500}
               syncPopupOnResize={false}
            />
         )}
      </FieldLayout>
   );
   // endregion
});

TrackerQueueField.displayName = 'TrackerQueueField';
