import { clearParams, FormFieldType, IFormField, isEmpty } from '@yandex-infracloud-ui/libs';

import { ReportsExtraFields } from './fields/ReportsExtraFields';
import { TrackerQueueField } from './fields/TrackerQueueField';
import { IProjectReports, IProjectReportsExtra } from './models';
import { BooleanSwitcherField } from 'rich_shared/form_fields';

export const reportsFields: IFormField<IProjectReports>[] = [
   {
      label: 'Enable',
      name: 'enabled',
      type: FormFieldType.Custom,
      component: BooleanSwitcherField,
      validationField: 'enabled',
   },
   {
      component: TrackerQueueField,
      isDisabled: p => !p.enabled,
      label: 'Tracker queue',
      name: 'queue',
      placeholder: 'Enter queue...',
      type: FormFieldType.Custom,
      validationField: 'queue',
   },
   {
      isDisabled: p => !p.enabled,
      label: 'Summary',
      name: 'summary',
      placeholder: 'Enter summary...',
      type: FormFieldType.Text,
      validationField: 'summary',
   },
   {
      component: ReportsExtraFields,
      isHidden: p => !p.enabled,
      name: 'extra',
      type: FormFieldType.Custom,
      validationField: 'extra',
   },
];

export const clearReportsExtraParams = (extra: IProjectReportsExtra) => {
   return Object.keys(extra).reduce((acc, field) => {
      const value = extra[field].trim();

      if (isEmpty(value)) {
         return acc;
      }

      acc[field] = value;

      return acc;
   }, {} as IProjectReportsExtra);
};

export const clearReportsParams = (reports: IProjectReports) => {
   const clearedReportsExtra = reports.extra ? clearReportsExtraParams(reports.extra) : undefined;

   return {
      ...clearParams(reportsFields, { ...reports, extra: clearedReportsExtra }),
      enabled: reports.enabled,
      queue: reports.queue, // TODO validation
   };
};
