import { getValidResult, IValidationResult, validateEntity } from '@yandex-infracloud-ui/libs';
import { areReportsValid, IProjectReports, reportsSchema } from './models';

// TODO вынести куда-нибудь
function createError(field: string, errors: string[]): IValidationResult<any> {
   return {
      errors: new Map([[field, errors]]),
      isValid: false,
   };
}

function getValidReports(): IProjectReports {
   return {
      enabled: true,
      extra: {
         status: 'done',
         tags: 'hello',
      },
      queue: 'TEST',
      summary: 'Text description',
   };
}

function isFieldValid(field: keyof IProjectReports, value: any) {
   return validateEntity(reportsSchema, [field], value, {});
}

describe('project report settings validation', () => {
   it('should test reports to be valid', () => {
      expect(areReportsValid(getValidReports())).toEqual(getValidResult());
   });

   describe('should validate enable', () => {
      it('should be valid', () => {
         expect(isFieldValid('enabled', { enabled: true })).toEqual(getValidResult());
      });

      it('should be invalid', () => {
         expect(isFieldValid('enabled', { enabled: 'correct' })).toEqual(
            createError('enabled', ['enabled must be a boolean type']),
         );
         expect(isFieldValid('enabled', {})).toEqual(createError('enabled', ['enabled is a required field']));
      });
   });

   describe('should validate queue', () => {
      it('should be valid', () => {
         expect(isFieldValid('queue', { enabled: true, queue: 'TEST' })).toEqual(getValidResult());
         expect(isFieldValid('queue', { enabled: false })).toEqual(getValidResult());
      });

      it('should be invalid', () => {
         expect(isFieldValid('queue', { enabled: true })).toEqual(createError('queue', ['queue is a required field']));
         expect(isFieldValid('queue', { enabled: true, queue: null })).toEqual(
            createError('queue', ['queue must be a string type']),
         );
      });
   });

   describe('should validate extra', () => {
      it('should be valid', () => {
         expect(isFieldValid('extra', { extra: {} })).toEqual(getValidResult());
         expect(isFieldValid('extra', { extra: undefined })).toEqual(getValidResult());
         expect(isFieldValid('extra', { extra: { tags: '123' } })).toEqual(getValidResult());
      });

      it('should be invalid', () => {
         expect(isFieldValid('extra', { extra: 123 })).toEqual(createError('extra', ['extra must be an object']));
         expect(isFieldValid('extra', { extra: { tags: 123 } })).toEqual(
            createError('extra', ['extra keys must be of string type']),
         );
      });
   });
});
