import { forHumanCapitalized, IListOption, validateEntity } from '@yandex-infracloud-ui/libs';
import { bool, object, string } from 'yup';

export interface IProjectReportsExtra {
   [key: string]: string;
}

export interface IProjectReports {
   enabled: boolean;
   extra?: IProjectReportsExtra;
   queue: string;
   summary?: string;
}

export const TICKET_SYSTEM_FIELDS: IListOption[] = [
   {
      name: 'Type',
      value: 'type',
   },
   {
      name: 'Priority',
      value: 'priority',
   },
   {
      name: 'Key',
      value: 'key',
   },
   {
      name: 'Aliases',
      value: 'aliases',
   },
   {
      name: 'Description',
      value: 'description',
   },
   {
      name: 'Description',
      value: 'descriptionHtml',
   },
   {
      name: 'Status',
      value: 'status',
   },
   {
      name: 'Resolution',
      value: 'resolution',
   },
   {
      name: 'Created',
      value: 'createdAt',
   },
   {
      name: 'Updated',
      value: 'updatedAt',
   },
   {
      name: 'Resolved',
      value: 'resolvedAt',
   },
   {
      name: 'Last Comment',
      value: 'lastCommentUpdatedAt',
   },
   {
      name: 'Start Date',
      value: 'start',
   },
   {
      name: 'End Date',
      value: 'end',
   },
   {
      name: 'Deadline',
      value: 'deadline',
   },
   {
      name: 'Goals',
      value: 'goals',
   },
   {
      name: 'Author',
      value: 'createdBy',
   },
   {
      name: 'Assignee',
      value: 'assignee',
   },
   {
      name: 'Followers',
      value: 'followers',
   },
   {
      name: 'Access',
      value: 'access',
   },
   {
      name: 'Modifier',
      value: 'updatedBy',
   },
   {
      name: 'Resolver',
      value: 'resolvedBy',
   },
   {
      name: 'Maillists',
      value: 'followingMaillists',
   },
   {
      name: 'Project',
      value: 'project',
   },
   {
      name: 'Tags',
      value: 'tags',
   },
   {
      name: 'Components',
      value: 'components',
   },
   {
      name: 'Affected Version',
      value: 'affectedVersions',
   },
   {
      name: 'Fix Version',
      value: 'fixVersions',
   },
   {
      name: 'OTRS Ticket',
      value: 'otrsTicket',
   },
   {
      name: 'UUID',
      value: 'unique',
   },
   {
      name: 'Followers (Groups)',
      value: 'followingGroups',
   },
   {
      name: 'Parent issue',
      value: 'parent',
   },
   {
      name: 'Previous Assignee',
      value: 'previousStatusLastAssignee',
   },
   {
      name: 'Previous Status',
      value: 'previousStatus',
   },
   {
      name: 'Old Queue',
      value: 'previousQueue',
   },
   {
      name: 'Voted By',
      value: 'votedBy',
   },
   {
      name: 'Votes',
      value: 'votes',
   },
   {
      name: 'Favorited By',
      value: 'favoritedBy',
   },
   {
      name: 'Number of comments without message',
      value: 'commentWithoutExternalMessageCount',
   },
   {
      name: 'Number of comments with message',
      value: 'commentWithExternalMessageCount',
   },
   {
      name: 'Boards',
      value: 'boards',
   },
   {
      name: 'Undefined message',
      value: 'statusStartTime',
   },
   {
      name: 'Checklist',
      value: 'checklistItems',
   },
   {
      name: 'Pending reply from',
      value: 'pendingReplyFrom',
   },
   {
      name: 'Checklist Done',
      value: 'checklistDone',
   },
   {
      name: 'Checklist Total',
      value: 'checklistTotal',
   },
   {
      name: 'Version',
      value: 'versionSingle',
   },
   {
      name: 'Server Version',
      value: 'serverVersion',
   },
   {
      name: 'ABC Service',
      value: 'abcService',
   },
];

/* eslint-disable no-template-curly-in-string */
const reportsShape = {
   enabled: bool().required('${path} is a required field').typeError('${path} must be a boolean type'),
   extra: object<IProjectReportsExtra>()
      .notRequired()
      .typeError('${path} must be an object')
      .test('keys are strings', '${path} keys must be of string type', value =>
         value ? Object.values(value).every(val => typeof val === 'string') : true,
      ),
   queue: string().when('enabled', {
      is: true,
      otherwise: string().notRequired(),
      then: string().required('${path} is a required field').typeError('${path} must be a string type'),
   }),
   summary: string().notRequired(),
};
/* eslint-enable no-template-curly-in-string */

export const reportsSchema = object().shape<Partial<IProjectReports>>(reportsShape);

export const areReportsValid = (reports: Partial<IProjectReports>) =>
   validateEntity(reportsSchema, Object.keys(reportsShape) as (keyof IProjectReports)[], reports, {});

export const getTrackerFieldName = (key: string) => {
   const systemField = TICKET_SYSTEM_FIELDS.find(f => f.value === key);

   return systemField ? systemField.name : forHumanCapitalized(key);
};
